#include <OneWire.h>
#include <DallasTemperature.h>


#define ONE_WIRE_BUS 10
#define TEMPERATURE_PRECISION 9

OneWire oneWire(ONE_WIRE_BUS);

DallasTemperature sensors(&oneWire);

DeviceAddress temp1 = { 0x28, 0x47, 0x00, 0x27, 0x00, 0x00, 0x80, 0x94 }; // 2847002700008094 --> oil temp
DeviceAddress temp2 = { 0x28, 0x82, 0xF9, 0x26, 0x00, 0x00, 0x80, 0x3A }; // 2882F9260000803A --> water temp
DeviceAddress temp3 = { 0x28, 0xD4, 0xE4, 0x26, 0x00, 0x00, 0x80, 0x36 }; // 28D4E42600008036 --> air temp post turbo
DeviceAddress temp4 = { 0x28, 0x3F, 0xD9, 0x26, 0x00 ,0x00, 0x80, 0x8F }; // 283FD9260000808F --> air temp before throttle

String dataOut;

int t1, t2, t3, t4, p1;

void setup() {
    Serial1.begin(115200);
    sensors.begin();
    sensors.getAddress(temp1, 2);
    sensors.getAddress(temp2, 1);
    sensors.getAddress(temp3, 0);
    sensors.getAddress(temp4, 3);
    sensors.setResolution(temp1, TEMPERATURE_PRECISION);
    sensors.setResolution(temp2, TEMPERATURE_PRECISION);
    sensors.setResolution(temp3, TEMPERATURE_PRECISION);
    sensors.setResolution(temp4, TEMPERATURE_PRECISION);
    sensors.setWaitForConversion(false);
    sensors.requestTemperatures();
}

void loop() {
  if(Serial1.available() > 0){
    Serial1.read();
    p1 = map(analogRead(A0), 102, 922, 0, 150);
    p1 = constrain(p1, 0, 140);
    t1 = sensors.getTempC(temp1);
    t2 = sensors.getTempC(temp2);
    t3 = sensors.getTempC(temp3);
    t4 = sensors.getTempC(temp4);
    sensors.requestTemperatures();
    sendData(p1);
    sendData(t1);
    sendData(t2);
    sendData(t3);
    sendData(t4);
    Serial1.print("z");
  }
}

void sendData(int d){
  if(d < 0){
    Serial1.print("000");
  } else if(d == 0){
    Serial1.print("000");
  } else if(d < 10){
    Serial1.print("00");
    Serial1.write(d);
  } else if(d < 100){
    Serial1.print("0");
    Serial1.print(d);
  } else {
    Serial1.print(d);
  }
}

