#include <genieArduino.h>

Genie genie;

#define RESETLINE 4  // Change this if you are not using an Arduino Adaptor Shield Version 2 (see code below)
#define DEBUG 0
#define OILPRES 1
#define OILTEMP 0
#define WATERTEMP 2
#define AIRTEMP1 3
#define AIRTEMP2 4
#define AFRSCOPE 0
#define BOOSTSCOPE 1

String datain, t1, t2, t3, t4, p1;
int temp1, temp2, temp3, temp4, pres1, temp1old = 0, temp2old = 0, temp3old = 0, temp4old = 0, pres1old = 0, afr1, boost, bright, oldBright = 0;
long j = 0, k = 0;

void setup()
{ 
  Serial.begin(200000);
  genie.Begin(Serial);
  delay (1000);
  bright = map(analogRead(A1), 0, 1000, 15, 0);
  bright = constrain(bright, 0, 15);
  genie.WriteContrast(bright);
  Serial1.begin(115200);
  Serial1.print("k");
  j = millis();
  //genie.WriteStr(DEBUG, "Initialising");
}

void loop(){
  bright = map(analogRead(A1), 0, 1000, 15, 0);
  bright = constrain(bright, 0, 15);
  if(bright != oldBright){
    oldBright = bright;
    genie.WriteContrast(bright);
  }
  while(millis() - j < 180){
    if(Serial1.available()) {
      Serial1.print('k');
      datain = Serial1.readStringUntil(122);
      //genie.WriteStr(DEBUG, datain);
      p1 = datain.substring(0,3);
      pres1 = p1.toInt();
      t1 = datain.substring(3,6);
      temp1 = t1.toInt();  
      t2 = datain.substring(6,9);
      temp2 = t2.toInt();    
      t3 = datain.substring(9,12);
      temp3 = t3.toInt();
      t4 = datain.substring(12,15);
      temp4 = t4.toInt();
      j = millis();
      k = 0;
      break;
    } else {
      pres1 = 0;
      temp1 = 0;
      temp2 = 0;
      temp3 = 0;
      temp4 = 0;
    }
  }
  if(pres1 != pres1old){
    genie.WriteObject(GENIE_OBJ_COOL_GAUGE, OILPRES, pres1);
    pres1old = pres1;
  }
  if(temp1 != temp1old){
    genie.WriteObject(GENIE_OBJ_COOL_GAUGE, OILTEMP, temp1);
    temp1old = temp1;
  }
  if(temp2 != temp2old){
    genie.WriteObject(GENIE_OBJ_COOL_GAUGE, WATERTEMP, temp2);
    temp2old = temp2;
  }
  if(temp3 != temp3old){
    genie.WriteObject(GENIE_OBJ_COOL_GAUGE, AIRTEMP1, temp3);
    temp3old = temp3;
  }
  if(temp4 != temp4old){
    genie.WriteObject(GENIE_OBJ_COOL_GAUGE, AIRTEMP2, temp4);
    temp4old = temp4;
  }
  afr1 = map(analogRead(A0), 0, 1024, 0, 90);
  afr1 = constrain(afr1, 0, 90);
  boost = map(analogRead(A2), 0, 1024, 0, 90);
  boost = constrain(boost, 0, 90);
  genie.WriteObject(GENIE_OBJ_SCOPE, AFRSCOPE, afr1);
  genie.WriteObject(GENIE_OBJ_SCOPE, BOOSTSCOPE, boost);
  k++;
  if(k > 10){
    Serial1.print("k");
    k = 0;
    j = millis();
  }
}

